% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{GeneID2entrez}
\alias{GeneID2entrez}
\title{Translates gene IDs from Gene Symbol or Ensembl ID to Entrez ID.}
\usage{
GeneID2entrez(gene.IDs, return.Matrix = FALSE, mode = "h2h")
}
\arguments{
\item{gene.IDs}{Array of Gene Symbols or Ensembl Gene IDs.}

\item{return.Matrix}{Logical. When TRUE, the function returns a matrix [n,2],
one column with the gene symbols or Ensembl IDs, another with their
respective Entrez IDs.}

\item{mode}{Specify the organism used: 'h2h' for human gene IDs,
'm2m' for mouse gene IDs, or 'm2h' for converting mouse to human gene IDs.}
}
\value{
Vector or matrix containing the Entrez IDs (or NA) corresponding
to every element of the input.
}
\description{
Translates mouse or human gene IDs from Gene Symbol or
Ensembl Gene ID to Entrez Gene ID using AnnotationDbi.
}
\examples{
GeneID2entrez(c('TNMD','DPM1','SCYL3','FGR','CFH','FUCA2','GCLC'))
}
