% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{rankTFs}
\alias{rankTFs}
\title{Rank the TFs in the output from 'getCMstats'}
\usage{
rankTFs(
  resultsTable,
  rankMethod = "gsea",
  makePlot = FALSE,
  plotTitle = "TF ranking"
)
}
\arguments{
\item{resultsTable}{Output from the function 'getCMstats'}

\item{rankMethod}{"wilcoxon" or "gsea".}

\item{makePlot}{(Optional) For rankMethod="gsea". If TRUE, generates 
a plot for TFs with a p-value < 0.05.}

\item{plotTitle}{(Optional) Title for the plot.}
}
\value{
data frame containing:
For Wilcoxon rank-sum test: rank, TF name, test statistic
('wilc_W), p-value, Freeman's theta, epsilon-squared, and effect size
For GSEA-like ranking: TF name, enrichment score, argument,
  p-value, number of ChIPs
}
\description{
Rank the TFs in the output from 'getCMstats' using
Wilcoxon rank-sum test or a GSEA-like approach.
}
\examples{
data('Genes.Upreg', package = 'TFEA.ChIP')
CM_list_UP <- contingency_matrix(Genes.Upreg)
stats_mat_UP <- getCMstats(CM_list_UP)
rankTFs(stats_mat_UP)
}
