% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{set_user_data}
\alias{set_user_data}
\title{Sets the data objects as default.}
\usage{
set_user_data(metadata, ChIPDB)
}
\arguments{
\item{metadata}{Data frame/matrix/array contaning the following fields:
'Name','Accession','Cell','Cell Type','Treatment','Antibody','TF'.}

\item{ChIPDB}{List containing two elements:
- Gene Keys: vector of gene IDs
- ChIP Targets: list of vectors, one per ChIP-seq experiment in the,
  database, containing the putative targets assigned. Each target is
  coded as its position in the vector 'Gene Keys'.}
}
\value{
sets the user's metadata table and TFBS matrix as the variables
'MetaData' and 'ChIPDB', used by the rest of the package.
}
\description{
Function to set the data objects provided by the user
as default to the rest of the functions.
}
\examples{
data( 'MetaData', 'ChIPDB', package='TFEA.ChIP' )
# For this example, we will use the variables already included in the
# package.
set_user_data( MetaData, ChIPDB )
}
