% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funcs.R
\name{plot2dTppFit}
\alias{plot2dTppFit}
\title{Plot H0 or H1 fit of 2D thermal profile intensities of 
a protein of choice}
\usage{
plot2dTppFit(
  df,
  name,
  model_type = "H0",
  optim_fun = .min_RSS_h0,
  optim_fun_2 = NULL,
  maxit = 500,
  xlab = "-log10(conc.)",
  ylab = "log2(summed intensities)",
  dot_size = 1,
  line_type = "solid",
  fit_color = "gray30"
)
}
\arguments{
\item{df}{tidy data frame of a 2D-TPP dataset}

\item{name}{gene name (clustername) of protein that 
should be visualized}

\item{model_type}{character string indicating whether
the "H0" or the "H1" model should be fitted}

\item{optim_fun}{optimization function that should be used
for fitting either the H0 or H1 model}

\item{optim_fun_2}{optional additional optimization function 
that will be run with paramters retrieved from optim_fun and 
should be used for fitting the H1 model with the trimmed sum
model, default is NULL}

\item{maxit}{maximal number of iterations the optimization
should be given, default is set to 500}

\item{xlab}{character string of x-axis label of plot}

\item{ylab}{character string of y-axis label of plot}

\item{dot_size}{numeric indicating the size of the data points
to plot}

\item{line_type}{character string defining the line type 
of the fitted curve, default "dashed"}

\item{fit_color}{character string defining the color
of the fitted curve}
}
\value{
A ggplot displaying the thermal profile of
a protein of choice in a datset of choice
}
\description{
Plot H0 or H1 fit of 2D thermal profile intensities of 
a protein of choice
}
\examples{

data("simulated_cell_extract_df")
plot2dTppProfile(simulated_cell_extract_df, "protein1")

}
