% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotUMI4C.R
\name{plotGenes}
\alias{plotGenes}
\title{Plot genes}
\usage{
plotGenes(
  window,
  TxDb = TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene,
  longest = TRUE,
  xlim = NULL,
  font_size = 14
)
}
\arguments{
\item{window}{\link[GenomicRanges]{GRanges-class} object with coordinates to use for
selecting the genes to plot.}

\item{TxDb}{TxDb object to use for drawing the genomic annotation.}

\item{longest}{Logical indicating whether to plot only the longest
transcripts for each gene in the gene annotation plot.}

\item{xlim}{Limits for the plot x axis (genomic coordinates).}

\item{font_size}{Base font size to use for the UMI4C plot. Default: 14.}
}
\value{
Produces a plot with the genes found in the provided \code{window}.
}
\description{
Plot genes in a window of interest.
}
\examples{
window <- GRanges("chr16:11348649-11349648")
plotGenes(
    window = window,
    TxDb = TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene
)
}
