% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward.R
\name{forward}
\alias{forward}
\title{Forward algorithm}
\usage{
forward(probabilities, trained_params)
}
\arguments{
\item{probabilities}{A matrix containing the marginal probability
distribution of the \eqn{K} states within the Markov model.}

\item{trained_params}{A list containing the initialised shape parameters for
the betaHMM model (initial distribution, transition matrix, shape parameters
for the observed data).}
}
\value{
A list containing:
\itemize{
\item log_alpha - A \eqn{C*K} matrix (where \eqn{C} is the number of CpG
sites and \eqn{K} is the number of hidden states) containing the
logarithmized forward probabilities.
\item scaled_logL - The log-likelihood calculated using the forward
probabilities.}
}
\description{
Computes the forward probabilities for \eqn{K} hidden states
using the initial distribution, transition matrix and distribution
parameters.
}
\keyword{internal}
