% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addClusterings.R
\name{addClusterings}
\alias{addClusterings}
\alias{removeClusterings}
\alias{addClusterings,ClusterExperiment,matrix-method}
\alias{addClusterings,ClusterExperiment,ClusterExperiment-method}
\alias{addClusterings,ClusterExperiment,vector-method}
\title{Add clusterings to ClusterExperiment object}
\usage{
\S4method{addClusterings}{ClusterExperiment,matrix}(
  x,
  y,
  clusterTypes = "User",
  clusterLabels = NULL,
  clusterLegend = NULL
)

\S4method{addClusterings}{ClusterExperiment,ClusterExperiment}(x, y, transferFrom = c("x", "y"), mergeCEObjects = FALSE)

\S4method{addClusterings}{ClusterExperiment,vector}(x, y, makePrimary = FALSE, ...)
}
\arguments{
\item{x}{a ClusterExperiment object}

\item{y}{additional clusters to add to x. Can be a ClusterExperiment object
or a matrix/vector of clusters.}

\item{clusterTypes}{a string describing the nature of the clustering. The
values `clusterSingle`, `clusterMany`, `mergeClusters`, `makeConsensus` are
reserved for the clustering coming from the package workflow and should not
be used when creating a new object with the constructor.}

\item{clusterLabels}{label(s) for the clusters being added. If \code{y} a
matrix, the column names of that matrix will be used by default, if
\code{clusterLabels} is not given.}

\item{clusterLegend}{a list giving the cluster legend for the clusters added.}

\item{transferFrom}{If x and y are both \code{ClusterExperiment} objects
indicates from which object the clustering info should be taken (regarding merging, dendrogram, etc). Does not affect the order of the clusterings, which will always be the clusterings of x, followed by those of y (along with slots `clusterType`, `clusterInfo`, `clusterLegend`)}

\item{mergeCEObjects}{logical If x and y are both \code{ClusterExperiment} objects indicates as to whether should try to grab in the information missing from x from y (or vice versa if transferFrom=y).}

\item{makePrimary}{whether to make the added cluster the primary cluster
(only relevant if \code{y} is a vector)}

\item{...}{For \code{addClusterings}, passed to signature
\code{ClusterExperiment,matrix}. For \code{[} (subsetting), passed to
\code{SingleCellExperiment} subsetting function.}
}
\value{
A \code{ClusterExperiment} object.
}
\description{
Function for adding new clusterings in form of vector (single
  cluster) or matrix (multiple clusterings) to an existing ClusterExperiment
  object
}
\details{
addClusterings adds y to x, and is thus not symmetric in the two
  arguments. In particular, the \code{primaryCluster}, all of the dendrogram
  information, the merge information, \code{coClustering}, and 
  \code{orderSamples} are all kept from
  the x object, even if y is a ClusterExperiment.
}
\examples{
data(simData)

cl1 <- clusterSingle(simData, subsample=FALSE,
sequential=FALSE, mainClusterArgs=list(clusterArgs=list(k=3), 
clusterFunction="pam"))
cl2 <- clusterSingle(simData, subsample=FALSE,
sequential=FALSE, mainClusterArgs=list(clusterArgs=list(k=3), 
clusterFunction="pam"))

addClusterings(cl1, cl2)
}
