% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusSeekeR.R
\docType{data}
\name{NucPosSimulator_nucleosome_ranges}
\alias{NucPosSimulator_nucleosome_ranges}
\title{Ranges associated to nucleosomes detected by the NucPosSimulator software
using syntetic reads generated using a normal distribution.
For demonstration purpose.}
\format{
A \code{GRanges} containing one entry per detected
nucleosome. The ranges are surronding the nucleosomes present in the dataset
\code{NucPosSimulator_nucleosome_positions}. The genomic ranges have been
obtained by adding 73 bps on each side of the detected positions.
}
\usage{
data(NucPosSimulator_nucleosome_ranges)
}
\description{
Ranges associated to nucleosomes detected by the NucPosSimulator software
using syntetic reads generated using a normal distribution with a variance
of 20 for regions chr1:10000-15000.
}
\examples{

## Loading datasets
data(PING_nucleosome_positions)
data(PING_nucleosome_ranges)
data(NOrMAL_nucleosome_positions)
data(NOrMAL_nucleosome_ranges)
data(NucPosSimulator_nucleosome_positions)
data(NucPosSimulator_nucleosome_ranges)

## Assigning experiment name to each row of the dataset.
## Position and range datasets from the same sofware must
## have identical names.
names(PING_nucleosome_positions) <- rep("PING",
                            length(PING_nucleosome_positions))
names(PING_nucleosome_ranges) <- rep("PING",
                            length(PING_nucleosome_ranges))
names(NOrMAL_nucleosome_positions) <-rep("NOrMAL",
                            length(NOrMAL_nucleosome_positions))
names(NOrMAL_nucleosome_ranges) <- rep("NOrMAL",
                            length(NOrMAL_nucleosome_ranges))
names(NucPosSimulator_nucleosome_positions) <-rep("NucPosSimulator",
                            length(NucPosSimulator_nucleosome_positions))
names(NucPosSimulator_nucleosome_ranges) <- rep("NucPosSimulator",
                            length(NucPosSimulator_nucleosome_ranges))

## Calculating consensus regions for chromosome 1
## with a default region size of 60 bp (2 * extendingSize).
## Consensus regions are resized to include all genomic regions of
## included nucleosomes.
## Nucleosomes from at least 2 software must be present
## in a region to be retained as a consensus region.
chrList <- Seqinfo(c("chr1"), c(249250621), NA)
findConsensusPeakRegions(
    narrowPeaks = c(PING_nucleosome_ranges,
                        NOrMAL_nucleosome_ranges,
                        NucPosSimulator_nucleosome_ranges),
    peaks = c(PING_nucleosome_positions,
                        NOrMAL_nucleosome_positions,
                        NucPosSimulator_nucleosome_positions),
    chrInfo = chrList,
    extendingSize = 30,
    expandToFitPeakRegion = TRUE,
    shrinkToFitPeakRegion = TRUE,
    minNbrExp = 2,
    nbrThreads = 1)

}
\references{
\itemize{
\item Sch&ouml;pflin R, Teif VB, M&uuml;ller O, Weinberg C, Rippe K, and
Wedemann G. 2013. Modeling nucleosome position distributions from
experimental nucleosome positioning maps. Bioinformatics 29 (19): 2380-86.
}
}
\seealso{
\itemize{
    \item{\code{\link{NucPosSimulator_nucleosome_positions}} the associate
genomic positions dataset.}
    \item{\code{\link{findConsensusPeakRegions}} for extracting regions
sharing nucleosomes from more than one experiment.}
}
}
\keyword{datasets}
