% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\docType{methods}
\name{CNV.detail}
\alias{CNV.detail}
\alias{CNV.detail,CNV.analysis-method}
\title{CNV.detail}
\usage{
CNV.detail(object, ...)

\S4method{CNV.detail}{CNV.analysis}(object)
}
\arguments{
\item{object}{\code{CNV.analysis} object.}

\item{...}{Additional parameters (\code{CNV.detail} generic, currently not used).}
}
\value{
\code{CNV.analysis} object.
}
\description{
Combine single probe values within detail regions.
}
\details{
The median intensity per detail region is calculated. Detail regions are defined using \code{CNV.create_anno(detail_bed=)}
}
\examples{
# prepare
library(minfiData)
data(MsetEx)
d <- CNV.load(MsetEx)
data(detail_regions)
anno <- CNV.create_anno(detail_regions = detail_regions)

# create object
x <- CNV.fit(query = d['GroupB_1'], ref = d[c('GroupA_1', 'GroupA_2', 'GroupA_3')], anno)

# modify object
x <- CNV.bin(x)
x <- CNV.detail(x)
#x <- CNV.segment(x)

# general information
x
show(x)

# coefficients of linear regression
coef(x)

# show or replace sample name
names(x)
names(x) <- 'Sample 1'
}
\author{
Volker Hovestadt \email{conumee@hovestadt.bio}
}
