% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\docType{methods}
\name{CNV.fit}
\alias{CNV.fit}
\alias{CNV.fit,CNV.data,CNV.data,CNV.anno-method}
\title{CNV.fit}
\usage{
CNV.fit(query, ref, anno, ...)

\S4method{CNV.fit}{CNV.data,CNV.data,CNV.anno}(query, ref, anno, name = NULL,
  intercept = TRUE)
}
\arguments{
\item{query}{\code{CNV.data} object of query sample (single sample).}

\item{ref}{\code{CNV.data} object of reference set.}

\item{anno}{\code{CNV.anno} object. Use \code{CNV.create_anno} do create.}

\item{...}{Additional parameters (\code{CNV.fit} generic, currently not used).}

\item{name}{character. Optional parameter to set query sample name.}

\item{intercept}{logical. Should intercept be considered? Defaults to \code{TRUE}.}
}
\value{
\code{CNV.analysis} object.
}
\description{
Normalize query sample intensities by fitting intensities to reference set using a linear regression model.
}
\details{
The log2 ratio of query intensities versus a linear combination of reference set intensities that best reflects query intensities is calculated (as determined by linear regression). The annotations provided to \code{CNV.fit} are saved within the returned \code{CNV.analysis} object and used for subsequent analysis steps.
}
\examples{
# prepare
library(minfiData)
data(MsetEx)
d <- CNV.load(MsetEx)
data(detail_regions)
anno <- CNV.create_anno(detail_regions = detail_regions)

# create object
x <- CNV.fit(query = d['GroupB_1'], ref = d[c('GroupA_1', 'GroupA_2', 'GroupA_3')], anno)

# modify object
#x <- CNV.bin(x)
#x <- CNV.detail(x)
#x <- CNV.segment(x)

# general information
x
show(x)

# coefficients of linear regression
coef(x)

# show or replace sample name
names(x)
names(x) <- 'Sample 1'
}
\author{
Volker Hovestadt \email{conumee@hovestadt.bio}
}
