% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\docType{methods}
\name{CNV.write}
\alias{CNV.write}
\alias{CNV.write,CNV.analysis-method}
\title{CNV.write}
\usage{
CNV.write(object, ...)

\S4method{CNV.write}{CNV.analysis}(object, file = NULL, what = "segments")
}
\arguments{
\item{object}{\code{CNV.analysis} object.}

\item{...}{Additional parameters (\code{CNV.write} generic, currently not used).}

\item{file}{Path where output file should be written to. Defaults to \code{NULL}: No file is written, table is returned as data.frame object.}

\item{what}{character. This should be (an unambiguous abbreviation of) one of \code{'probes'}, \code{'bins'}, \code{'detail'} or \code{'segments'}. Defaults to \code{'segments'}.}
}
\value{
if parameter \code{file} is not supplied, the table is returned as a \code{data.frame} object.
}
\description{
Output CNV analysis results as table.
}
\examples{
# prepare
library(minfiData)
data(MsetEx)
d <- CNV.load(MsetEx)
data(detail_regions)
anno <- CNV.create_anno(detail_regions = detail_regions)

# create/modify object
x <- CNV.segment(CNV.detail(CNV.bin(CNV.fit(query = d['GroupB_1'],
    ref = d[c('GroupA_1', 'GroupA_2', 'GroupA_3')], anno))))

# output plots
CNV.genomeplot(x)
CNV.genomeplot(x, chr = 'chr6')
CNV.detailplot(x, name = 'PTEN')
CNV.detailplot_wrap(x)

# output text files
CNV.write(x, what = 'segments')
CNV.write(x, what = 'detail')
CNV.write(x, what = 'bins')
CNV.write(x, what = 'probes')
}
