% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epigraHMM.R
\name{epigraHMM}
\alias{epigraHMM}
\title{Perform peak calling of epigenomic data sets}
\usage{
epigraHMM(object, control, type, dist = "nb")
}
\arguments{
\item{object}{an epigraHMMDataSet}

\item{control}{list of control arguments from \code{\link{controlEM}}}

\item{type}{character, either \code{"consensus"} or \code{"differential"}}

\item{dist}{character, either \code{"zinb"} or \code{"nb"} (default)}
}
\value{
An epigraHMMDataSet object with the results from epigraHMM
}
\description{
This function runs either consensus (one condition, multiple samples) or
differential (multiple conditions and samples) peak callers for epigenomic
data.
}
\examples{

# Creating dummy object
countData <- rbind(matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1),
                   matrix(rnbinom(2e3,mu = 7.5,size = 5),ncol = 1),
                   matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1))

colData <- data.frame(condition = 'A', replicate = 1)
object <- epigraHMMDataSetFromMatrix(countData,colData)

# Initializing
object <- initializer(object,controlEM())

# Running epigraHMM
object <- epigraHMM(object,controlEM(),type = 'consensus',dist = 'nb')

}
\references{
\url{https://github.com/plbaldoni/epigraHMM}
}
\author{
Pedro L. Baldoni, \email{pedrobaldoni@gmail.com}
}
