% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geseca-plot.R
\name{plotGesecaTable}
\alias{plotGesecaTable}
\title{Plots table of gene set profiles.}
\usage{
plotGesecaTable(
  gesecaRes,
  pathways,
  E,
  center = TRUE,
  scale = FALSE,
  colwidths = c(5, 3, 0.8, 1.2, 1.2),
  titles = colnames(E),
  colors = rdbuColors,
  pathwayLabelStyle = NULL,
  headerLabelStyle = NULL,
  valueStyle = NULL,
  axisLabelStyle = NULL,
  axisLabelHeightScale = NULL,
  minLimit = -3,
  maxLimit = 3
)
}
\arguments{
\item{gesecaRes}{Table with geseca results.}

\item{pathways}{Pathways to plot table, as in `geseca` function.}

\item{E}{gene expression matrix, as in `geseca` function.}

\item{center}{a logical value indicating whether the gene expression should be centered to have zero mean before the analysis takes place.
The default is TRUE. The value is passed to \link[base]{scale}.}

\item{scale}{a logical value indicating whether the gene expression should be scaled to have unit variance before the analysis takes place.
The default is FALSE. The value is passed to \link[base]{scale}.}

\item{colwidths}{Vector of five elements corresponding to column width for
grid.arrange. Can be both units and simple numeric vector, in latter case
it defines proportions, not actual sizes. If column width is set to zero, the column is not drawn.}

\item{titles}{sample titles to use an axis labels. Default to `colnames(E)`}

\item{colors}{vector of colors to use in the color scheme (default is similar to "RdBu" Brewer's color palette)}

\item{pathwayLabelStyle}{list with style parameter adjustments for pathway labels.
For example, `list(size=10, color="red")` set the font size to 10 and color to red.
See `cowplot::draw_text` for possible options.}

\item{headerLabelStyle}{similar to `pathwayLabelStyle` but for the table header.}

\item{valueStyle}{similar to `pathwayLabelStyle` but for pctVar and p-value columns.}

\item{axisLabelStyle}{list with style parameter adjustments for sample labels.
See `ggplot2::element_text` for possible options.}

\item{axisLabelHeightScale}{height of the row with axis labels compared to other rows.
When set to `NULL` the value is determined automatically.}

\item{minLimit}{Numeric value specifying the minimum limit for the color scale.
This defines the lower bound of the z-score used in coloring the feature plot.
Values below this limit are squished to the minimum color.}

\item{maxLimit}{Numeric value specifying the maximum limit for the color scale.
This defines the upper bound of the z-score used in coloring the feature plot.
Values above this limit are squished to the maximum color.}
}
\value{
ggplot object with gene set profile plots
}
\description{
Plots table of gene set profiles.
}
