% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findBorderCells.R
\name{findBorderCells}
\alias{findBorderCells}
\title{Find cells at the image border}
\usage{
findBorderCells(object, img_id, border_dist, coords = c("Pos_X", "Pos_Y"))
}
\arguments{
\item{object}{a \code{SingleCellExperiment} or \code{SpatialExperiment}
object.}

\item{img_id}{single character indicating the \code{colData(object)} entry
containing the unique image identifiers.}

\item{border_dist}{single numeric defining the distance to the image border.
The image border here is defined as the minimum and maximum among the 
cells' x and y location.}

\item{coords}{character vector of length 2 specifying the names of the
\code{colData} (for a \code{SingleCellExperiment} object) or the
\code{spatialCoords} entries indicating the cells' x and y locations.}
}
\value{
an object of \code{class(object)} containing the logical
\code{border_cells} entry in the \code{colData} slot.
}
\description{
Detection of cells close to the image border for subsequent exclusion from
downstream analyses.
}
\examples{
library(cytomapper)
data("pancreasSCE")

sce <- findBorderCells(pancreasSCE, img_id = "ImageNb", 
                       border_dist = 10)

plotSpatial(sce, 
            img_id = "ImageNb", 
            node_color_by = "border_cells",
            scales = "free")

}
