% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{estBetaAlpha}
\alias{estBetaAlpha}
\title{Estimate the alpha parameter of a Beta distribution}
\usage{
estBetaAlpha(meanCtrl, varCtrl, minVal = 1e-06)
}
\arguments{
\item{meanCtrl}{a \code{double}, the mean of the controls (CTRL) at a 
specific CpG site.}

\item{varCtrl}{a \code{double}, the variance of the controls 
(CTRL) at a specific CpG site.}

\item{minVal}{a \code{double}, the minimum value accepted for the mean
value. If \code{meanCtrl} is smaller than 
\code{minVal}, then \code{minVal} is used in the calculation of the alpha
parameter. 
Default: \code{1e-06}.}
}
\value{
a \code{double}, the alpha parameter of a Beta distribution.
}
\description{
Estimate the alpha parameter from the mean and the variance
of a Beta distribution.
}
\examples{

## Estimate alpha parameters with mean = 0.5 and variance = 0.1
methInheritSim:::estBetaAlpha(meanCtrl = 0.5, varCtrl = 0.1)

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
