% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{getDiffMeth}
\alias{getDiffMeth}
\title{Identify differentially methylated sites and among those, the ones
that are inherited.}
\usage{
getDiffMeth(stateInfo, rateDiff, minRate, propInherite, c = 1, b = -0.1,
  endLength = 1000)
}
\arguments{
\item{stateInfo}{a \code{GRanges} that contains the CpG (or methylated 
sites).
The \code{GRanges} have four metadata from the real dataset:
\itemize{
\item chrOri, the chromosome from the real dataset
\item startOri, the position of the site in the real dataset
\item meanCTRL, the mean of the control in the real dataset
\item varCTRL, the variance of the control in the real dataset
}}

\item{rateDiff}{a positive \code{double} inferior to \code{1}, the mean of 
the chance that a site is differentially 
methylated.}

\item{minRate}{a non-negative \code{double} inferior to \code{1}, the 
minimum rate for differentially methylated sites.}

\item{propInherite}{a non-negative \code{double} inferior or equal 
to \code{1}, 
the proportion of differentially methylated regions that 
are inherated.}

\item{c}{a positive \code{double}, a factor in the formula to compute the 
probabylity of site to be diffentially methylated in a differentially
methylated region. 
The probability formula of site in differentially methylated region is
\code{c} * exp(\code{b} * log(distance with the preceding sites))
Default: \code{1.0}.}

\item{b}{a negative \code{double}, a factor in the formula to compute the 
probabylity of site to be diffentially methylated in a differentially
methylated region. 
The probability formula of site in differentially methylated region is
\code{c} * exp(\code{b} * log(distance with the preceding sites)). 
Default: \code{-1e-01}.}

\item{endLength}{a positive \code{integer}, when the distance with the 
preceding sites in a differentially
methylated region is larger than \code{endLength}, the differentially
methylated region is finished. Default: \code{1000}.}
}
\value{
a \code{list} containing the 2 following elements:
\itemize{
\item \code{stateDiff} a \code{vector} of \code{integer} (\code{0} 
and \code{1}) with length corresponding the length of \code{stateInfo}.
The \code{vector}
indicates, using \code{1}, the positions where the CpG sites are
differentially methylated.
\item \code{stateInherite} a \code{vector} of \code{integer} (\code{0} and 
\code{1})
with length corresponding the length of \code{stateInfo}. The 
\code{vector}
indicates, using \code{1}, the positions where the CpG values are
inherited.
}
}
\description{
Identify the site positions where the cases are differentially 
methylated and, among those, the one that are inherited.
}
\examples{

## Load dataset containing a list of objects used by 
## methInheritSim internal functions
data(dataSimExample)

## Identify differentially methylated sites and among those, the ones
## that are inherited
methInheritSim:::getDiffMeth(stateInfo = 
    dataSimExample$stateInfo, rateDiff = 0.3, minRate = 0.3,
    propInherite = 0.3)

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
