% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methInheritSim.R
\docType{data}
\name{samplesForChrSynthetic}
\alias{samplesForChrSynthetic}
\title{All samples information, formated by \code{methylKit}, in a
\code{methylBase} format (for demo purpose).}
\format{A \code{methylBase} object contains the information for one 
generation. Each sample information is
stored in a \code{methylRaw} object. There is \code{methylRaw} objects
 (6 controls and 6 cases).}
\usage{
data(samplesForChrSynthetic)
}
\value{
A \code{methylBase} contains the information for one generation.
Each sample information is stored in a \code{methylRaw} object. 
There is \code{methylRaw} objects
(6 controls and 6 cases).
}
\description{
The object is a \code{methylBase}.
There is 12 samples (6 controls and 6 cases). Each
sample information is stored in a \code{methylRaw} object.
}
\details{
This dataset can be
used to test the \code{runSim} function.
}
\examples{

## Loading dataset
data(samplesForChrSynthetic)

## Set the output directory where files will be created
temp_dir <- "test_samplesForChrSynthetic"

## Create 4 simulated dataset (nbSimulation) 
## over 3 generations (nbGenration = 3) with
## 6 cases and 6 controls (nNbsample = 6) using only one set
## of parameters (vpDiff = 0.85, vpDiffsd = 0.1, vDiff = 0.8)
runSim(outputDir = temp_dir, fileID = "F1", nbSynCHR = 1, 
    methData = samplesForChrSynthetic, nbSimulation = 4, 
    nbBlock = 10, nbCpG = 20,
    nbGeneration = 3, vNbSample = c(6), vpDiff = c(0.85), 
    vpDiffsd = c(0.1), vDiff = c(0.8), 
    vInheritance = c(0.5), propInherite = 0.3,
    rateDiff = 0.3, minRate = 0.2, propHetero = 0.5, 
    nbCores = 1, vSeed = 32)

## Delete the output directory and its content
if (dir.exists(temp_dir)) {
    unlink(temp_dir, recursive = TRUE, force = FALSE)
}

}
\seealso{
\itemize{
\item \code{\link{runSim}} {for running a
simulation analysis using methylKit info as input}
}
}
\keyword{datasets}
