% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{testIfAlreadyDone}
\alias{testIfAlreadyDone}
\title{Test if a specific simulation has already be done.}
\usage{
testIfAlreadyDone(pathOut, preference, id, saveGRanges, saveMethylKit,
  runAnalysis)
}
\arguments{
\item{pathOut}{a string of \code{character}, the path 
where the files are saved.}

\item{preference}{a string of \code{character} representing the 
parameters of specific simulation.}

\item{id}{a positive \code{integer}, a ID for the current simulation.}

\item{saveGRanges}{a \code{logical}, when \code{true}, files containing 
\code{GRangeaList} are saved.}

\item{saveMethylKit}{a \code{logical}, when \code{TRUE}, files 
\code{methylRawList} object are saved.}

\item{runAnalysis}{a \code{logical}, when \code{TRUE}, two files related
to the analysis are saved.}
}
\value{
\code{logical} indicating if the simulation has already done.
}
\description{
Test if a specific simulation has already be done.
}
\examples{

## Return TRUE when the specified simulation has already be done;
## otherwise, return FALSE.
methInheritSim:::testIfAlreadyDone(pathOut = ".", 
preference = "S1_6_0.9_0.8_0.5", id = 33, 
saveGRanges = FALSE, saveMethylKit = FALSE, runAnalysis = FALSE)

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
