% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{validateRunSimLogicalParameters}
\alias{validateRunSimLogicalParameters}
\title{Parameters validation for the \code{\link{runSim}} function. Only 
logical parameters are validated.}
\usage{
validateRunSimLogicalParameters(keepDiff, saveGRanges, saveMethylKit,
  runAnalysis)
}
\arguments{
\item{keepDiff}{\code{logical} if true, the differentially methyled sites
will be the same for each parameter (\code{vpDiff}, 
\code{vDiff} and \code{vInheritance}). Default: \code{FALSE}.}

\item{saveGRanges}{a \code{logical}, when \code{true}, the package save two 
files type. The first generate for each simulation contains a \code{list}. 
The length of the \code{list} corresponds to the number of generation. 
The generation are stored in order (first entry = first generation, 
second entry = second generation, etc..). All samples related to one 
generations are contained in a \code{GRangesList}. 
The \code{GRangeaList} store a \code{list} of \code{GRanges}. Each 
\code{GRanges} stores the raw mehylation data of one sample.
The second file a numeric \code{vector} denoting controls and cases 
(a file is generates by entry in the \code{vector} parameters 
\code{vNbSample}).}

\item{saveMethylKit}{a \code{logical}, when \code{TRUE}, for each 
simulations save a file contains a \code{list}. The length of the 
\code{list} corresponds to the number of generation. The generation are 
stored in order (first entry = first generation, 
second entry = second generation, etc..). All samples related to one 
generations are contained in a S4 \code{methylRawList} object. The 
\code{methylRawList} object contains two Slots:
1. treatment: A numeric \code{vector} denoting controls and cases.
2. .Data: A \code{list} of \code{methylRaw} objects. Each object stores the 
raw methylation data of one sample.}

\item{runAnalysis}{a \code{logical}, if \code{TRUE}, two files are saved 
for each simulation:
\itemize{
\item 1. The first file is the methylObj... file formated with 
the \code{methylkit} package in a S4 \code{methylBase} object 
(with the \code{methylKit} functions: \code{filterByCoverage}, 
\code{normalizeCoverage} and \code{unite}).
\item 2. The second file contains a S4 \code{calculateDiffMeth} object 
generated with the \code{methylKit} functions \code{calculateDiffMeth} on 
the first file.
}}
}
\value{
\code{0} indicating that the function has been successful.
}
\description{
Validation of all parameters needed by the public
\code{\link{runSim}} function. Only logical parameters are validated.
}
\examples{

## Load dataset
data("samplesForChrSynthetic")

## The function returns 0 when all paramaters are valid
methInheritSim:::validateRunSimLogicalParameters(keepDiff = FALSE, 
saveGRanges = TRUE, saveMethylKit = FALSE, runAnalysis = FALSE)

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
