% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{validateRunSimOtherParameters}
\alias{validateRunSimOtherParameters}
\title{Parameters validation for the \code{\link{runSim}} function. Only 
parameters other than double, integer and logical are validated.}
\usage{
validateRunSimOtherParameters(outputDir, fileID, methData, context, assembly)
}
\arguments{
\item{outputDir}{a string of \code{character} or \code{NULL}, the path 
where the 
files created by the function will be saved. When \code{NULL}, the files
are saved in the current directory.}

\item{fileID}{a string of \code{character}, a identifiant that will be 
included in each output file name. Each output 
file name is 
composed of those elements, separated by "_":
\itemize{ 
\item a type name, ex: methylGR, methylObj, etc..
\item a \code{fileID}
\item the chromosome number, a number between 1 and \code{nbSynCHR}
\item the number of samples, a number in the \code{vNbSample} \code{vector}
\item the mean proportion of samples that has,
for a specific position, differentially methylated values, a 
number in the \code{vpDiff} \code{vector}
\item the proportion of 
C/T for a case differentially methylated that follows a shifted beta 
distribution, a
number in the \code{vDiff} \code{vector}
\item the 
proportion of cases that inherits differentially sites, a number in the
\code{vInheritance} \code{vector}
\item the identifiant for the simulation, a number 
between 1 and \code{nbSimulation}
\item the file extension ".rds"
}}

\item{methData}{an object of class \code{methylBase}, the CpG information
from controls (CTRL) that will be used to create the sythetic chromosome. 
The \code{methData} object can also contain information from cases but 
only the controls will be used.}

\item{context}{a string of \code{character}, the methylation context 
string, ex: CpG,CpH,CHH, etc.}

\item{assembly}{a string of \code{character}, the short description of the 
genome assembly. Ex: mm9,hg18 etc.}
}
\value{
\code{0} indicating that the function has been successful.
}
\description{
Validation of all parameters needed by the public
\code{\link{runSim}} function. Only parameters other than double, integer
and logical are validated.
}
\examples{

## Load dataset
data("samplesForChrSynthetic")

## The function returns 0 when all paramaters are valid
methInheritSim:::validateRunSimOtherParameters(
outputDir = "test", fileID = "test", methData = samplesForChrSynthetic, 
context = "CpG", assembly = "Rnor_5.0")

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
