% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotHistogram.R
\name{plotHistogram}
\alias{plotHistogram}
\alias{plotBarplot}
\alias{plotHistogram,SummarizedExperiment-method}
\alias{plotBarplot,SummarizedExperiment-method}
\title{Create histogram or barplot of \code{assay}, \code{rowData} or \code{colData}}
\usage{
plotHistogram(x, ...)

plotBarplot(x, ...)

\S4method{plotHistogram}{SummarizedExperiment}(
  x,
  assay.type = NULL,
  features = NULL,
  row.var = NULL,
  col.var = NULL,
  ...
)

\S4method{plotBarplot}{SummarizedExperiment}(
  x,
  assay.type = NULL,
  features = NULL,
  row.var = NULL,
  col.var = NULL,
  ...
)
}
\arguments{
\item{x}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{...}{Additional parameters for plotting.
\itemize{
\item \code{layout}: \code{Character scalar}. Specifies the layout of plot.
Must be either \code{"histogram"} or \code{"density"}.
(Default: \code{"histogram"})
\item \code{facet.by}: \code{Character vector}. Specifies variables from
\code{colData(x)} or \code{rowData(x)} used for facetting.
(Default: \code{NULL})
\item \code{fill.by}: \code{Character scalar}. Specifies variable from
\code{colData(x)} or \code{rowData(x)} used for coloring.
(Default: \code{NULL})
}}

\item{assay.type}{\code{NULL} or \code{character scalar}. Specifies the
abundace table to plot. (Default: \code{NULL})}

\item{features}{\code{NULL} or \code{character vector}. If \code{assay.type}
is specified, this specifies rows to visualize in different facets. If
\code{NULL}, whole data is visualized as a whole. (Default: \code{NULL})}

\item{row.var}{\code{NULL} or \code{character vector}. Specifies a variable
from \code{rowData(x)} to visualize. (Default: \code{NULL})}

\item{col.var}{\code{NULL} or \code{character vector} Specifies a variable
from \code{colData(x)} to visualize. (Default: \code{NULL})}
}
\value{
A \code{ggplot2} object.
}
\description{
This methods visualizes abundances or variables from \code{rowData} or
\code{colData}.
}
\details{
Histogram and bar plot are a basic visualization techniques in quality
control. It helps to visualize the distribution of data. \code{plotAbundance}
allows researcher to visualise the abundance from \code{assay}, or variables
from \code{rowData} or \code{colData}. For visualizing categorical values,
one can utilize \code{plotBarplot}.

\code{\link[=plotAbundanceDensity]{plotAbundanceDensity}} function is related
to \code{plotHistogram}. However, the former visualizes the most prevalent
features, while the latter can be used more freely to explore the
distributions.
}
\examples{
data(GlobalPatterns)
tse <- GlobalPatterns

# Visualize the counts data. There are lots of zeroes.
plotHistogram(tse, assay.type = "counts")

# Apply transformation
tse <- transformAssay(tse, method = "clr", pseudocount = TRUE)
# And plot specified rows
plotHistogram(
    tse,
    assay.type = "clr",
    features = rownames(tse)[1:5],
    facet.by = "rownames"
)

# Calculate shannon diversity and visualize its distribution with density
# plot. Different sample types are separated with color.
tse <- addAlpha(tse, index = "shannon")
plotHistogram(
    tse,
    col.var = "shannon",
    layout = "density",
    fill.by = "SampleType"
)

# For categorical values, one can utilize a bar plot
plotBarplot(tse, col.var = "SampleType")

}
\seealso{
\itemize{
\item \code{\link[=plotAbundanceDensity]{plotAbundanceDensity}}
\item \code{\link[scater:plotExpression]{scater::plotExpression}}
\item \code{\link[scater:plotRowData]{scater::plotRowData}}
\item \code{\link[scater:plotColData]{scater::plotColData}}
}
}
