% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotSeries.R
\name{plotSeries}
\alias{plotSeries}
\alias{plotSeries,SummarizedExperiment-method}
\title{Plot Series}
\usage{
plotSeries(x, ...)

\S4method{plotSeries}{SummarizedExperiment}(
  x,
  time.col,
  assay.type = NULL,
  col.var = NULL,
  features = NULL,
  facet.by = NULL,
  ...
)
}
\arguments{
\item{x}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{...}{additional parameters for plotting.
\itemize{
\item \code{rank} \code{Character scalar}. A taxonomic rank, that is used
to agglomerate the data. (Default: \code{NULL})

\item \code{colour.by} \code{Character scalar}. A column name from
\code{rowData(x)} or \code{colData(x)}, that is used to divide observations
to different colors. If \code{NULL}, this is not applied.
(Default: \code{NULL})

\item \code{linetype.by} \code{Character scalar}. A column name from
\code{rowData(x)} or \code{colData(x)}, that is used to divide observations
to different line types. If \code{NULL}, this is not applied.
(Default: \code{NULL})

\item \code{size.by}: \code{Character scalar}. A column name from
\code{rowData(x)} or \code{colData(x)}, that is used to divide observations
to different size types. If \code{NULL}, this is not applied.
(Default: \code{NULL})

\item \code{ncol}: \code{Numeric scalar}. if facets are applied,
\code{ncol} defines many columns should be for plotting the different
facets. (Default: \code{1L})

\item \code{scales} \code{Character scalar}. Defines the behavior of the
scales of each facet. The value is passed into
\code{\link[ggplot2:facet_wrap]{facet_wrap}}. (Default: \code{"fixed"})
}
See \code{\link{mia-plot-args}} for more details i.e. call
\code{help("mia-plot-args")}}

\item{time.col}{\code{Character scalar}. Selecting the column from
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{colData}} that
will specify values of x-axis.}

\item{assay.type}{\code{Character scalar}. Specifies the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assay}} to be
plotted.}

\item{col.var}{\code{Character scalar}. Selecting the column from
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{colData}} that
will be plotted. This can be used instead of \code{assay.type} for
visualizing temporal changes in sample metadata variable.}

\item{features}{\code{Character scalar}. Selects the taxa from
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{rownames}}.
This parameter specifies taxa whose abundances will be plotted.}

\item{facet.by}{\code{Character scalar}. Specifies a sample grouping. Must be
value from
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{rowData}} or
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{colData}}. If
\code{NULL}, grouping is not applied. (Default: \code{NULL})}
}
\value{
A \code{ggplot2} object
}
\description{
This function plots time series data.
}
\details{
This function creates series plot, where x-axis includes e.g. time points,
and y-axis abundances of selected taxa. If there are multiple observations
for single system and time point, mean and standard deviation is plotted.
}
\examples{
\dontrun{
library(mia)
# Load data from miaTime package
library("miaTime")
data(SilvermanAGutData)
tse <- SilvermanAGutData

# Plots 2 most abundant taxa, which are colored by their family
plotSeries(
    tse,
    assay.type = "counts",
    time.col = "DAY_ORDER",
    features = getTop(tse, 2),
    colour.by = "Family"
)

# Counts relative abundances
tse <- transformAssay(tse, method = "relabundance")

# Selects taxa
taxa <- c("seq_1", "seq_2", "seq_3", "seq_4", "seq_5")

# Plots relative abundances of phylums
plotSeries(
    tse[taxa,],
    time.col = "DAY_ORDER",
    colour.by = "Family",
    linetype.by = "Phylum",
    assay.type = "relabundance"
)

# In addition to 'colour.by' and 'linetype.by', 'size.by' can also be used
# to group taxa.
plotSeries(
    tse,
    time.col = "DAY_ORDER",
    features = getTop(tse, 5),
    colour.by = "Family",
    size.by = "Phylum",
    assay.type = "counts"
)

# If the data includes multiple systems, e.g., patients or bioreactors,
# one can plot each system separately
plotSeries(
    tse,
    time.col = "DAY_ORDER",
    assay.type = "relabundance",
    features = getTop(tse, 5),
    facet.by = "Vessel",
    colour.by = "rownames", colour.lab = "Feature",
    linetype.by = "Pre_Post_Challenge",
    scales = "free"
)

# One can visualize colData variables by specifying col.var
# First calculate alpha diversity index to visualize.
tse <- addAlpha(tse, index = "shannon")
# Then create a plot
plotSeries(
    tse,
    col.var = "shannon",
    time.col = "DAY_ORDER",
    facet.by = "Vessel",
)

}
}
