% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfm.R
\docType{class}
\name{pfm-class}
\alias{pfm-class}
\alias{pfm}
\alias{$,pfm-method}
\alias{$<-,pfm-method}
\alias{plot,pfm,ANY-method}
\alias{coerce}
\alias{coerce,pfm,matrix-method}
\alias{getIC,pfm,ANY-method}
\alias{getIC,matrix,numeric-method}
\alias{getIC,matrix,matrix-method}
\alias{trimMotif,pfm,numeric-method}
\alias{matrixReverseComplement,pfm-method}
\alias{addBlank,pfm,numeric,logical-method}
\alias{as.data.frame,pfm-method}
\alias{format,pfm-method}
\title{Class \code{"pfm"}}
\usage{
\S4method{$}{pfm}(x, name)

\S4method{plot}{pfm,ANY}(x, y = "missing", ...)

\S4method{getIC}{pfm,ANY}(x, p = "missing")

\S4method{trimMotif}{pfm,numeric}(x, t)

\S4method{matrixReverseComplement}{pfm}(x)

\S4method{addBlank}{pfm,numeric,logical}(x, n, b)

\S4method{as.data.frame}{pfm}(x, row.names = NULL, optional = FALSE, ...)

\S4method{format}{pfm}(x, ...)
}
\arguments{
\item{x}{An object of class \code{pfm}. For \code{getIC}, if parameter p is
followed, x should be an object of matrix.}

\item{name}{Slot name.}

\item{y}{Not use.}

\item{\dots}{Further potential arguments passed to \code{plotMotifLogo}.}

\item{p}{p is the background frequency.}

\item{t}{numeric value of information content threshold for trimming.}

\item{n}{how many spaces should be added.}

\item{b}{logical value to indicate where the space should be added.}

\item{row.names, optional}{see as.data.frame}
}
\description{
An object of class \code{"pfm"} represents the position frequency matrix of
a DNA/RNA/amino-acid sequence motif. The entry stores a matrix, which in row
i, column j gives the frequency of observing nucleotide/or amino acid i in
position j of the motif.

methods for pfm objects.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("pfm", mat, name, alphabet, color, background)}.
}

\section{Methods}{
 \describe{ \item{addBlank}{\code{signature(x="pfm",
n="numeric", b="logical")} add space into the position frequency matrix for
alignment. b is a bool value, if TRUE, add space to the 3' end, else add
space to the 5' end. n indicates how many spaces should be added.}

\item{getIC}{\code{signature(x = "pfm",)} Calculate information content
profile for position frequency matrix. }

\item{getIC}{\code{signature(x = "matrix", p = "numeric")} Calculate
information content profile for matrix. p is the background frequency}

\item{matrixReverseComplement}{\code{signature(x = "pfm")} get the reverse
complement of position frequency matrix.}

\item{plot}{\code{signature(x = "pfm")} Plots the sequence logo of the
position frequency matrix. }

\item{trimMotif}{\code{signature(x = "pfm", t= "numeric")} trim motif by
information content. }

\item{$, $<-}{Get or set the slot of \code{\link{pfm-class}}}
\item{as.data.frame}{convert \code{\link{pfm-class}} to a data.frame}
\item{format}{return the name_pfm of \code{\link{pfm-class}}} }
}

\examples{

pcm <- read.table(file.path(find.package("motifStack"), "extdata", "bin_SOLEXA.pcm"))
pcm <- pcm[,3:ncol(pcm)]
rownames(pcm) <- c("A","C","G","T")
motif <- pcm2pfm(pcm)
motif <- new("pfm", mat=motif, name="bin_SOLEXA")
plot(motif)


pcm <- read.table(file.path(find.package("motifStack"), "extdata", "bin_SOLEXA.pcm"))
pcm <- pcm[,3:ncol(pcm)]
rownames(pcm) <- c("A","C","G","T")
motif <- pcm2pfm(pcm)
motif <- new("pfm", mat=motif, name="bin_SOLEXA")
getIC(motif)
matrixReverseComplement(motif)
addBlank(motif, 1, FALSE)
addBlank(motif, 3, TRUE)
as(motif,"matrix")
as.data.frame(motif)
format(motif)

}
\keyword{classes}
