% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_functions.R
\name{getSignificant}
\alias{getSignificant}
\title{Filter to only QTLs significant in at least one state}
\usage{
getSignificant(qtle, n = 1, assaySig = "significant", verbose = FALSE)
}
\arguments{
\item{qtle}{`QTLExperiment` object}

\item{n}{Number (or percent if n < 1) of states with significant association}

\item{assaySig}{The assay containing TRUE/FALSE significance calls for each QTL
test.}

\item{verbose}{logical. Whether to print progress messages.}
}
\value{
a subset of the `QTLExperiment` object, where all rows are
  significant in at least one state.
}
\description{
Filter to only QTLs significant in at least one state
}
\examples{

qtle <- mockQTLE()

qtle <- callSignificance(qtle)
dim(qtle)
qtle_sig <- getSignificant(qtle)

# There are fewer rows because we have removed tests which are not significant
# in any state.  
dim(qtle_sig)

}
