% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resDS.R
\name{resDS}
\alias{resDS}
\title{resDS
Formatting of DS analysis results}
\usage{
resDS(
  x,
  y,
  bind = c("row", "col"),
  frq = FALSE,
  cpm = FALSE,
  digits = 3,
  sep = "__",
  ...
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{y}{a list of DS testing results as returned 
by \code{\link{pbDS}} or \code{\link{mmDS}}.}

\item{bind}{character string specifying the output format (see details).}

\item{frq}{logical or a pre-computed list of expression frequencies 
as returned by \code{\link{calcExprFreqs}}.}

\item{cpm}{logical specifying whether CPM by cluster-sample 
should be appendeded to the output result table(s).}

\item{digits}{integer value specifying the 
number of significant digits to maintain.}

\item{sep}{character string to use as separator 
when constructing new column names.}

\item{...}{optional arguments passed to 
\code{\link{calcExprFreqs}} if \code{frq = TRUE}.}
}
\value{
returns a `data.frame`.
}
\description{
\code{resDS} provides a simple wrapper to format cluster-level
differential testing results into an easily filterable table, and
to optionally append gene expression frequencies by cluster-sample
& -group, as well as cluster-sample-wise CPM.
}
\details{
When \code{bind = "col"}, the list of DS testing results at 
\code{y$table} will be merge vertically (by column) into a single table
in tidy format with column \code{contrast/coef} specifying the comparison.
  
Otherwise, when \code{bind = "row"}, an identifier of the respective
contrast or coefficient will be appended to the column names,
and all tables will be merge horizontally (by row).
  
Expression frequencies pre-computed with \code{\link{calcExprFreqs}} 
may be provided with \code{frq}. Alternatively, when \code{frq = TRUE}, 
expression frequencies can be computed directly, and additional arguments 
may be passed to \code{\link{calcExprFreqs}} (see examples below).
}
\examples{
# compute pseudobulks (sum of counts)
data(example_sce)
pb <- aggregateData(example_sce, 
  assay = "counts", fun = "sum")

# run DS analysis (edgeR on pseudobulks)
res <- pbDS(pb, method = "edgeR")

head(resDS(example_sce, res, bind = "row")) # tidy format
head(resDS(example_sce, res, bind = "col", digits = Inf))

# append CPMs & expression frequencies
head(resDS(example_sce, res, cpm = TRUE))
head(resDS(example_sce, res, frq = TRUE))

# pre-computed expression frequencies & append
frq <- calcExprFreqs(example_sce, assay = "counts", th = 0)
head(resDS(example_sce, res, frq = frq))

}
\author{
Helena L Crowell & Mark D Robinson
}
