% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSnSet.R
\name{markerMSnSet}
\alias{markerMSnSet}
\alias{unknownMSnSet}
\title{Extract marker/unknown subsets}
\usage{
markerMSnSet(object, fcol = "markers")

unknownMSnSet(object, fcol = "markers")
}
\arguments{
\item{object}{An instance of class \code{MSnSet}}

\item{fcol}{The name of the feature data column, that will be used
to separate the markers from the proteins of unknown
localisation. When the markers are encoded as vectors, features of
unknown localisation are defined as \code{fData(object)[, fcol] ==
"unknown"}. For matrix-encoded markers, unlabelled proteins are
defined as \code{rowSums(fData(object)[, fcol]) == 0}. Default is
\code{"markers"}.}
}
\value{
An new \code{MSnSet} with marker/unknown proteins only.
}
\description{
These function extract the marker or unknown proteins into a new
\code{MSnSet}.
}
\examples{
library("pRolocdata")
data(dunkley2006)
mrk <- markerMSnSet(dunkley2006)
unk <- unknownMSnSet(dunkley2006)
dim(dunkley2006)
dim(mrk)
dim(unk)
table(fData(dunkley2006)$markers)
table(fData(mrk)$markers)
table(fData(unk)$markers)
## matrix-encoded markers
dunkley2006 <- mrkVecToMat(dunkley2006)
dim(markerMSnSet(dunkley2006, "Markers"))
stopifnot(all.equal(featureNames(markerMSnSet(dunkley2006, "Markers")),
                    featureNames(markerMSnSet(dunkley2006, "markers"))))
dim(unknownMSnSet(dunkley2006, "Markers"))
stopifnot(all.equal(featureNames(unknownMSnSet(dunkley2006, "Markers")),
                    featureNames(unknownMSnSet(dunkley2006, "markers"))))
}
\seealso{
\code{\link{sampleMSnSet}} \code{\link{testMSnSet}} and
\code{\link{markers}} for markers encoding.
}
\author{
Laurent Gatto
}
