% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markers.R
\name{mrkVecToMat}
\alias{mrkVecToMat}
\alias{markers}
\alias{mrkMatToVec}
\alias{mrkMatAndVec}
\alias{showMrkMat}
\alias{isMrkMat}
\alias{isMrkVec}
\alias{mrkEncoding}
\title{Create a marker vector or matrix.}
\usage{
mrkVecToMat(object, vfcol = "markers", mfcol = "Markers")

mrkMatToVec(object, mfcol = "Markers", vfcol = "markers")

mrkMatAndVec(object, vfcol = "markers", mfcol = "Markers")

showMrkMat(object, mfcol = "Markers")

isMrkMat(object, fcol = "Markers")

isMrkVec(object, fcol = "markers")

mrkEncoding(object, fcol = "markers")
}
\arguments{
\item{object}{An \code{MSnSet} object}

\item{vfcol}{The name of the \emph{vector} marker feature
variable. Default is \code{"markers"}.}

\item{mfcol}{The name of the \emph{matrix} marker feature
variable. Default is \code{"Markers"}.}

\item{fcol}{A marker feature variable name.}
}
\value{
An updated \code{MSnSet} with a new vector (matrix) marker
set.
}
\description{
Functions producing a new vector (matrix) marker vector set from
an existing matrix (vector) marker set.
}
\details{
Sub-cellular markers can be encoded in two different ways. Sets of
spatial markers can be represented as character \emph{vectors}
(\code{character} or \code{factor}, to be accurate), stored as
feature metadata, and proteins of unknown or uncertain
localisation (unlabelled, to be classified) are marked with the
\code{"unknown"} character. While very handy, this encoding
suffers from some drawbacks, in particular the difficulty to label
proteins that reside in multiple (possible or actual)
localisations. The markers vector feature data is typically named
\code{markers}. A new \emph{matrix} encoding is also
supported. Each spatial compartment is defined in a column in a
binary markers matrix and the resident proteins are encoded with
1s. The markers matrix feature data is typically named
\code{Markers}. If proteins are assigned unique localisations only
(i.e. no multi-localisation) or their localisation is unknown
(unlabelled), then both encodings are equivalent. When the markers
are encoded as vectors, features of unknown localisation are
defined as \code{fData(object)[, fcol] == "unknown"}. For
matrix-encoded markers, unlabelled proteins are defined as
\code{rowSums(fData(object)[, fcol]) == 0}.

The \code{mrkMatToVec} and \code{mrkVecToMat} functions enable the
conversion from matrix (vector) to vector (matrix). The
\code{mrkMatAndVec} function generates the missing encoding from
the existing one. If the destination encoding already exists, or,
more accurately, if the feature variable of the destination
encoding exists, an error is thrown. During the conversion from
matrix to vector, if multiple possible label exists, they are
dropped, i.e. they are converted to \code{"unknown"}. Function
\code{isMrkVec} and \code{isMrkMat} can be used to test if a
marker set is encoded as a vector or a matrix. \code{mrkEncoding}
returns either \code{"vector"} or \code{"matrix"} depending on the
nature of the markers.
}
\examples{
library("pRolocdata")
data(dunkley2006)
dunk <- mrkVecToMat(dunkley2006)
head(fData(dunk)$Markers)
fData(dunk)$markers <- NULL
dunk <- mrkMatToVec(dunk)
stopifnot(all.equal(fData(dunkley2006)$markers,
                    fData(dunk)$markers))
}
\seealso{
Other functions that operate on markers are
\code{\link{getMarkers}}, \code{\link{getMarkerClasses}} and
\code{\link{markerMSnSet}}. To add markers to an existing
\code{MSnSet}, see the \code{\link{addMarkers}} function and
\code{\link{pRolocmarkers}}, for a list of suggested markers.
}
\author{
Laurent Gatto and Lisa Breckels
}
