% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-nnet.R
\name{nnetOptimisation}
\alias{nnetOptimisation}
\alias{nnetRegularisation}
\alias{nnetOptimization}
\title{nnet parameter optimisation}
\usage{
nnetOptimisation(
  object,
  fcol = "markers",
  decay = c(0, 10^(-1:-5)),
  size = seq(1, 10, 2),
  times = 100,
  test.size = 0.2,
  xval = 5,
  fun = mean,
  seed,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{decay}{The hyper-parameter. Default values are \code{c(0, 10^(-1:-5))}.}

\item{size}{The hyper-parameter. Default values are \code{seq(1, 10, 2)}.}

\item{times}{The number of times internal cross-validation is performed.
Default is 100.}

\item{test.size}{The size of test data. Default is 0.2 (20 percent).}

\item{xval}{The \code{n}-cross validation. Default is 5.}

\item{fun}{The function used to summarise the \code{xval} macro F1 matrices.}

\item{seed}{The optional random number generator seed.}

\item{verbose}{A \code{logical} defining whether a progress bar is displayed.}

\item{...}{Additional parameters passed to \code{\link{nnet}} from package \code{nnet}.}
}
\value{
An instance of class \code{"\linkS4class{GenRegRes}"}.
}
\description{
Classification parameter optimisation for artificial neural network
algorithm.
}
\details{
Note that when performance scores precision, recall and (macro) F1
are calculated, any NA values are replaced by 0. This decision is
motivated by the fact that any class that would have either a NA
precision or recall would result in an NA F1 score and,
eventually, a NA macro F1 (i.e. mean(F1)). Replacing NAs by 0s
leads to F1 values of 0 and a reduced yet defined final macro F1
score.
}
\examples{
library(pRolocdata)
data(dunkley2006)
## reducing parameter search space and iterations 
params <- nnetOptimisation(dunkley2006, decay = 10^(c(-1, -5)), size = c(5, 10), times = 3)
params
plot(params)
f1Count(params)
levelPlot(params)
getParams(params)
res <- nnetClassification(dunkley2006, params)
getPredictions(res, fcol = "nnet")
getPredictions(res, fcol = "nnet", t = 0.75)
plot2D(res, fcol = "nnet")
}
\seealso{
\code{\link{nnetClassification}} and example therein.
}
\author{
Laurent Gatto
}
