% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDegTx.R
\name{getDegTx}
\alias{getDegTx}
\title{Obtain expression matrix for degraded transcripts}
\usage{
getDegTx(
  rse_tx,
  sig_transcripts = select_transcripts(),
  assayname = "tpm",
  verbose = TRUE
)
}
\arguments{
\item{rse_tx}{A \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object containing the transcript data desired to be studied.}

\item{sig_transcripts}{A \code{character()} vector of transcripts that should be
associated with degradation, expected to be present in \code{rownames(rse_tx)}.}

\item{assayname}{character string specifying the name of the assay desired in rse_tx}

\item{verbose}{specify if the function should report how many model transcripts were matched}
}
\value{
A
\link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object.
}
\description{
This function is used to obtain a \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
of transcripts and their expression values #' These transcripts are selected based on a prior study of RNA degradation in
postmortem brain tissues. This object can later be used to obtain the principle components
necessary to remove the effect of degradation in differential expression.
}
\examples{
degTx <- getDegTx(rse_tx)
}
