% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{which_tx_names}
\alias{which_tx_names}
\title{Check validity of transcript vectors and return a vector matching indexes in tx1}
\usage{
which_tx_names(txnames, sig_tx)
}
\arguments{
\item{txnames}{A \code{character()} vector of GENCODE or ENSEMBL transcript IDs.}

\item{sig_tx}{A \code{character()} vector of GENCODE or ENSEMBL signature transcript IDs.}
}
\value{
A
\code{integer()} vector of \code{txnames} transcript indexes in \code{sig_tx}.
}
\description{
This function is used to check if tx1 and tx2 are GENCODE or ENSEMBL transcript IDs
and return an integer vector of tx1 transcript indexes that are in tx2.
}
\examples{
sig_tx <- select_transcripts(cell_component = TRUE)
whichTx <- which_tx_names(rownames(rse_tx), sig_tx)
}
