% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available_projects.R
\name{available_samples}
\alias{available_samples}
\title{List available samples in recount3}
\usage{
available_samples(
  organism = c("human", "mouse"),
  recount3_url = getOption("recount3_url", "http://duffel.rail.bio/recount3"),
  bfc = recount3_cache(),
  verbose = getOption("recount3_verbose", TRUE),
  available_homes = project_homes(organism = organism, recount3_url = recount3_url)
)
}
\arguments{
\item{organism}{A \code{character(1)} specifying which organism you want to
download data from. Supported options are \code{"human"} or \code{"mouse"}.}

\item{recount3_url}{A \code{character(1)} specifying the home URL for \code{recount3}
or a local directory where you have mirrored \code{recount3}. Defaults to the
load balancer \url{http://duffel.rail.bio/recount3}, but can also be
\url{https://recount-opendata.s3.amazonaws.com/recount3/release} from
\url{https://registry.opendata.aws/recount/} or from
IDIES at JHU \url{https://idies.jhu.edu/recount3/data} (which redirects to
\url{https://data.idies.jhu.edu/recount3/data/}). You can
set the R option \code{recount3_url} (for example in your \code{.Rprofile}) if
you have a favorite mirror.}

\item{bfc}{A \link[BiocFileCache:BiocFileCache-class]{BiocFileCache-class}
object where the files will be cached to, typically created by
\code{recount3_cache()}.}

\item{verbose}{A \code{logical(1)} indicating whether to show messages with
updates.}

\item{available_homes}{A \code{character()} vector with the available project homes
for the given \code{recount3_url}. If you use a non-standard \code{recount3_url}, you
will likely need to specify manually the valid values for \code{available_homes}.}
}
\value{
A \code{data.frame()} with the sample ID used by the original source of
the data (\code{external_id}), the project ID (\code{project}), the \code{organism}, the
\code{file_source} from where the data was accessed, the date the sample
was processed (\code{date_processed}) in \code{YYYY-MM-DD} format,
the \code{recount3} project home location (\code{project_home}), and the project
\code{project_type} that differentiates between \code{data_sources} and \code{compilations}.
}
\description{
This function returns a \code{data.frame()} with the samples that are available
from \code{recount3}. Note that a specific sample might be available from a
given \code{data_source} and none or many \code{collections}.
}
\examples{

## Find all the human samples available from recount3
human_samples <- available_samples()
dim(human_samples)
head(human_samples)

## How many are from a data source vs a compilation?
table(human_samples$project_type, useNA = "ifany")

## What are the unique file sources?
table(
    human_samples$file_source[human_samples$project_type == "data_sources"]
)

## Find all the mouse samples available from recount3
mouse_samples <- available_samples("mouse")
dim(mouse_samples)
head(mouse_samples)

## How many are from a data source vs a compilation?
table(mouse_samples$project_type, useNA = "ifany")
}
