% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_retrieve.R
\name{file_retrieve}
\alias{file_retrieve}
\title{Download a remote file and cache it to re-use later}
\usage{
file_retrieve(
  url,
  bfc = recount3_cache(),
  verbose = getOption("recount3_verbose", TRUE)
)
}
\arguments{
\item{url}{A \code{character(1)} with the file URL or the actual local path in
which case, it won't be cached. If \code{length(url) > 1} , this function
will be used recursively.}

\item{bfc}{A \link[BiocFileCache:BiocFileCache-class]{BiocFileCache-class}
object where the files will be cached to, typically created by
\code{recount3_cache()}.}

\item{verbose}{A \code{logical(1)} indicating whether to show messages with
updates.}
}
\value{
A \code{character(1)} with the path to the cached file.
}
\description{
Download a remote file and cache it to re-use later
}
\examples{

## Download the metadata file for project SRP009615
url_SRP009615_meta <- locate_url(
    "SRP009615",
    "data_sources/sra"
)
local_SRP009615_meta <- file_retrieve(
    url = url_SRP009615_meta
)
local_SRP009615_meta

## Download the gene counts file for project SRP009615
url_SRP009615_gene <- locate_url(
    "SRP009615",
    "data_sources/sra",
    type = "gene"
)
local_SRP009615_gene <- file_retrieve(
    url = url_SRP009615_gene
)
local_SRP009615_gene
}
\seealso{
Other internal functions for accessing the recount3 data: 
\code{\link{annotation_ext}()},
\code{\link{create_rse_manual}()},
\code{\link{locate_url}()},
\code{\link{locate_url_ann}()},
\code{\link{project_homes}()},
\code{\link{read_counts}()},
\code{\link{read_metadata}()}
}
\concept{internal functions for accessing the recount3 data}
