% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalOverlay.R
\name{clonalOverlay}
\alias{clonalOverlay}
\title{Visualize Distribution of Clonal Frequency}
\usage{
clonalOverlay(
  sc.data,
  reduction = NULL,
  cut.category = "clonalFrequency",
  cutpoint = 30,
  bins = 25,
  pt.size = 0.5,
  pt.alpha = 1,
  facet.by = NULL,
  ...
)
}
\arguments{
\item{sc.data}{The single-cell object after \code{\link[=combineExpression]{combineExpression()}}.}

\item{reduction}{The dimensional reduction to visualize.}

\item{cut.category}{Meta data variable of the single-cell object to use for
filtering.}

\item{cutpoint}{The overlay cut point to include, this corresponds to the
cut.category variable in the meta data of the single-cell object.}

\item{bins}{The number of contours to the overlay}

\item{pt.size}{The point size for plotting (default is 0.5)}

\item{pt.alpha}{The alpha value for plotting (default is 1)}

\item{facet.by}{meta data variable to facet the comparison}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object visualizing distributions of clones along a
dimensional reduction within the single-cell object
}
\description{
This function allows the user to visualize the clonal expansion by overlaying the
cells with specific clonal frequency onto the dimensional reduction plots in Seurat.
Credit to the idea goes to Drs Andreatta and Carmona and their work with
\href{https://github.com/carmonalab/ProjecTILs}{ProjectTIL}.
}
\examples{
# Getting the combined contigs
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))
# Getting a sample of a Seurat object
scRep_example <- get(data("scRep_example"))

# Using combineExpresion()
scRep_example <- combineExpression(combined, 
                                   scRep_example)

# Using clonalOverlay()
clonalOverlay(scRep_example, 
              reduction = "umap", 
              cutpoint = 3, 
              bins = 5) 

}
\author{
Francesco Mazziotta, Nick Borcherding
}
\concept{SC_Functions}
