% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCircilize.R
\name{getCirclize}
\alias{getCirclize}
\title{Generate Data Frame to Plot Cord Diagram}
\usage{
getCirclize(
  sc.data,
  cloneCall = "strict",
  group.by = NULL,
  proportion = FALSE,
  include.self = TRUE
)
}
\arguments{
\item{sc.data}{The single-cell object after \code{\link[=combineExpression]{combineExpression()}}.}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{group.by}{A column header in the metadata  to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed by active
identity.}

\item{proportion}{Calculate the relationship unique
clones (proportion = FALSE) or normalized by
proportion (proportion = TRUE)}

\item{include.self}{Include counting the clones within a single group.by
comparison}
}
\value{
A data frame of shared clones between groups formatted for
\link[circlize:chordDiagram]{chordDiagram}
}
\description{
This function will take the meta data from the product of
\code{\link[=combineExpression]{combineExpression()}} and generate a relational data frame to
be used for a chord diagram. Each cord will represent the number of
clone unique and shared across the multiple \code{group.by} variable.
If using the downstream circlize R package, please read and cite the
following \href{https://pubmed.ncbi.nlm.nih.gov/24930139/}{manuscript}.
If looking for more advance ways for circular visualizations, there
is a great \href{https://jokergoo.github.io/circlize_book/book/}{cookbook}
for the circlize package.
}
\examples{
# Getting the combined contigs
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Getting a sample of a Seurat object
scRep_example <- get(data("scRep_example"))
scRep_example <- combineExpression(combined, 
                                   scRep_example)

# Getting data frame output for Circlize
circles <- getCirclize(scRep_example, 
                       group.by = "seurat_clusters")


}
\author{
Dillon Corvino, Nick Borcherding
}
\concept{SC_Functions}
