% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLISA.R
\name{plotLISA}
\alias{plotLISA}
\title{Plotting LISA (e.g. moran)}
\usage{
plotLISA(
  spe,
  lisa,
  overlay = c("grid", "point"),
  type = c("cluster", "logpvalue"),
  reverseY = NULL,
  ...
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{lisa}{Output from localMoran}

\item{overlay}{Option of grid or point. Depend on whether
\link[scider]{localMoran} is calculated at grid or point.}

\item{type}{Option of cluster or logpvalue for plotting lisa's cluster or
p-value, respectively.}

\item{reverseY}{Logical. Whether to reverse Y coordinates. Default is TRUE
if the spe contains an image (even if not plotted) and FALSE if otherwise.}

\item{...}{Parameters pass to \link[scider]{plotGrid} or
\link[scider]{plotSpatial}, depending on overlay.}
}
\value{
a ggplot object
}
\description{
Plotting LISA (e.g. moran)
}
\examples{
data("xenium_bc_spe")
spe <- gridDensity(spe, coi = "Breast cancer")
dat <- spe@metadata$grid_density$density_breast_cancer
spe <- findNbrsGrid(spe)
res <- localMoran(spe,data1=dat, at = "grid")
plotLISA(spe,lisa = res)

}
