% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScpModel-Utils.R
\name{ScpModel-DataCorrection}
\alias{ScpModel-DataCorrection}
\alias{scpKeepEffect}
\alias{scpRemoveBatchEffect}
\title{Correct single-cell proteomics data}
\usage{
scpKeepEffect(object, effects = NULL, intercept = FALSE, name)

scpRemoveBatchEffect(object, effects = NULL, intercept = TRUE, name)
}
\arguments{
\item{object}{An object that inherits from the
\code{SummarizedExperiment} class. It must contain an estimated
\code{ScpModel} in its metadata}

\item{effects}{A \code{character()} vector. For \code{scpKeepEffect()},
which model variable should be used to reconstruct the data.
For \code{scpRemoveBatchEffect()}, which model variable should be
removed from the data. When \code{NULL} (default), both functions
return the model residuals.}

\item{intercept}{A \code{logical(1)}. For \code{scpKeepEffect()},
should the intercepts be included when reconstructing the
data? Defaults to \code{FALSE}, hence the intercepts are not
included. For \code{scpRemoveBatchEffect()}, should the intercepts
be removed from the data? Defaults to \code{TRUE}, hence the
intercepts are removed from the data.}

\item{name}{A \code{character(1)} providing the name to use to retrieve
the model results. When retrieving a model and \code{name} is
missing, the name of the first model found in \code{object} is used.}
}
\description{
The function uses the data modelling output to generate corrected
data that can be used for downstream analysis. The input
is expected to be a \code{SummarizedExperiment} object that contains an
estimated \code{ScpModel}. There are two approaches:
\itemize{
\item \code{scpKeepEffect()}: keep the effects of interests. The
reconstructed data is the sum of the effect matrices for the
variable of interest and the residuals. Note that the intercepts
(baseline intensity of each feature) are not included by
default, but they can be added when \code{intercept = TRUE}.
\item \code{scpRemoveBatchEffect()}: remove any undesired effect. The batch
corrected data is the input data minus the effect matrices that
correspond to batch effect variables. Note that the intercepts
(baseline intensity of each feature) are removed by default, but
they can be kept when \code{intercept = FALSE}.
}

Despite the two approaches are conceptually different, they can
lead to similar results if the effects that are used to
reconstruct the data are the ones that are not removed when
performing batch correction (see examples).

The function returns a new \code{SummarizedExperiment} that contains an
assay with the batch corrected data. Note that the 'ScpModel` is
erased in this new object.
}
\examples{
data("leduc_minimal")
scpModelFormula(leduc_minimal)

reconstructed <- scpKeepEffect(leduc_minimal, effects = "SampleType")
batchCorreced <- scpRemoveBatchEffect(
    leduc_minimal, effects = c("Channel", "Set", "MedianIntensity")
)
## The two approaches are identical
identical(reconstructed, batchCorreced)
}
\seealso{
\itemize{
\item \linkS4class{ScpModel} for functions to extract information from the
\code{ScpModel} object
\item \link{ScpModel-Workflow} to run a model on SCP data required for
batch correction.
}
}
\author{
Christophe Vanderaa, Laurent Gatto
}
