% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScpModel-Class.R
\docType{class}
\name{ScpModel}
\alias{ScpModel}
\alias{ScpModel-class}
\alias{class:ScpModel}
\alias{scpModelFormula}
\alias{scpModelInput}
\alias{scpModelFilterThreshold}
\alias{scpModelFilterNPRatio}
\alias{scpModelResiduals}
\alias{scpModelEffects}
\alias{scpModelNames}
\alias{scpModelFilterThreshold<-}
\title{Class to store the results of single-cell proteomics
modelling}
\usage{
scpModelFormula(object, name)

scpModelInput(object, name, filtered = TRUE)

scpModelFilterThreshold(object, name)

scpModelFilterNPRatio(object, name, filtered = TRUE)

scpModelResiduals(object, name, join = TRUE, filtered = TRUE)

scpModelEffects(object, name, join = TRUE, filtered = TRUE)

scpModelNames(object)

scpModelFilterThreshold(object, name) <- value
}
\arguments{
\item{object}{An object that inherits from the
\code{SummarizedExperiment} class.}

\item{name}{A \code{character(1)} providing the name to use to store or
retrieve the modelling results. When retrieving a model and
\code{name} is missing, the name of the first model found in
\code{object} is used.}

\item{filtered}{A \code{logical(1)} indicating whether the output
should return all features (\code{FALSE}) or the features that
comply to the n/p ratio threshold (\code{TRUE}).}

\item{join}{A \code{logical(1)} indicating whether the output should be
combined in a single matrix (\code{TRUE}) or it should be returned
as a list with one element for each feature (\code{FALSE}). When
\code{TRUE}, any gaps across features will be filled with NA's.}

\item{value}{An \code{numeric(1)}, the new value for the n/p ratio
threshold}
}
\description{
An \code{ScpModel} object must be always stored in the \code{metadata()} of
an object that inherits from the \code{SummarizedExperiment} class. The
\code{ScpModel} object should \strong{never be accessed directly} by the
user. Instead, we provide several setter function to retrieve
information that may be useful to the user.The \code{ScpModel} class
contains several slots:
\itemize{
\item \code{scpModelFormula}: a \code{formula} object controlling which
variables are to be modelled.
\item \code{scpModelInputIndex}: a \code{numeric(1)}, selecting the assay to use
in the \code{SummarizedExperiment} object as input matrix. Note that
this slot serves as a pointer, meaning that the quantitative
data is not duplicated. Any change to the assay in the
\code{SummarizedExperiment} will impact the estimation of the
\code{ScpModel} object.
\item \code{scpModelFilterThreshold}: A \code{numeric(1)} indicating the minimal
n/p ratio required for a feature to be included in further model
exploration. n/p is the number of measured values for a features
divided by the number of coefficients to estimate. n/p cannot be
smaller than 1 because this would lead to over-specified models.
\item \code{scpModelFitList}: A \code{List} that contains the model results for
each feature. Each element is a \code{ScpModelFit} object (see
\code{\linkS4class{ScpModelFit}})
}
}
\section{Getters}{


Each slot has a getter function associated:
\itemize{
\item \code{scpModelNames()}: returns a vector of names of \code{ScpModel}
objects stored in the \code{SummarizedExperiment} object.
\item \code{scpModelFormula()}: returns the \code{formula} slot of the \code{ScpModel}
within an object that inherits from the \code{SummarizedExperiment}
class.
\item \code{scpModelFilterThreshold()}: returns the n/p ration threshold
used for feature filtering.
\item \code{scpModelInput()}: returns a \code{matrix} with the quantitative
values used as input of the model. Hence, the matrix contains
the data before modelling. If \code{filtered = TRUE}, the feature of
the matrix are restricted to the features that satisfy the n/p
ratio threshold.
\item \code{scpModelFilterNPRatio()}: returns the computed n/p ratio for
each feature. If \code{filtered = TRUE}, the function returns only
the n/p of the features that satisfy the n/p ratio threshold.
\item \code{scpModelResiduals()}: when \code{join = FALSE}, the function returns
a list where each element corresponds to a feature and contains
the estimated residuals. When \code{join = TRUE} (default), the function
combines the list into a matrix with features in rows and cells
in columns, and filling the gaps with \code{NA}. If \code{filtered = TRUE},
the feature of the matrix are restricted to the features that
satisfy the n/p ratio threshold.
\item \code{scpModelEffects()}: when \code{join = FALSE}, the function return a
list where each element of the list corresponds to a feature.
Each element contains another list with as many elements as
variable in the model and each element contains the data  effect vector
for that vector. When \code{join = TRUE} (default), each element of the list is
a matrix with features in rows and cells in columns where gaps
are filled with \code{NA}. If \code{filtered = TRUE}, the feature of the
matrix are restricted to the features that satisfy the n/p
ratio threshold.
}

Setter:
\itemize{
\item \verb{scpModelFilterThreshold<-()}: the function changes the n/p
ratio threshold used for filtering features.
}
}

\examples{

data("leduc_minimal")

####---- Getters ----####

scpModelNames(leduc_minimal)

scpModelFormula(leduc_minimal)

dim(leduc_minimal)
dim(scpModelInput(leduc_minimal))
dim(scpModelInput(leduc_minimal, filtered = FALSE))

head(scpModelFilterNPRatio(leduc_minimal))

dim(scpModelResiduals(leduc_minimal))
dim(scpModelResiduals(leduc_minimal, filtered = FALSE))
scpModelResiduals(leduc_minimal, join = FALSE)

scpModelEffects(leduc_minimal)
dim(scpModelEffects(leduc_minimal)$Set)
dim(scpModelEffects(leduc_minimal, filtered = FALSE)$Set)
scpModelEffects(leduc_minimal, join = FALSE)[[1]]

scpModelFilterThreshold(leduc_minimal)

####---- Setter ----####

scpModelFilterThreshold(leduc_minimal) <- 2
scpModelFilterThreshold(leduc_minimal)
}
\seealso{
\itemize{
\item \linkS4class{ScpModelFit} for a description of the class that store
modelling results
\item \link{ScpModel-Workflow} that uses the class to store the estimated
model.
}
}
\author{
Christophe Vanderaa, Laurent Gatto
}
