% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{leduc_minimal}
\alias{leduc_minimal}
\title{Minimally processed single-cell proteomics data set}
\format{
An object of class \code{SingleCellExperiment} with 200 rows and 73 columns.
}
\usage{
data("leduc_minimal")
}
\description{
A \code{SingleCellExperiment} object that has been minimally processed.
The data set is published by Leduc et al. 2022 (see references)
and retrieved using \code{scpdata::leduc2022_pSCoPE()}. The data
processing was conducted with \code{QFeatures} and \code{scp}. Quality control
was performed, followed by building the peptide data and
log2-transformation. To limit the size of the data, only cells
associated to the 3 first and 3 last MS acquisition runs were
kept. For the same reason, 200 peptides were randomly
sampled. Therefore, the data set consists of 200 peptides and
73 cells. Peptide annotations can be retrieved from the \code{rowData}
and cell annotations can be retrieved from the \code{colData}.
}
\section{Quality control}{


Any zero value has been replaced by NA.

A peptide was removed from the data set if:
\itemize{
\item it matched to a decoy or contaminant peptide
\item it had an parental ion fraction below 60 \\%
\item it had a DART-ID adjusted q-value superior to 1\\%
\item it had an average sample to carrier ratio above 0.05
}

A cell was removed from the data set if:
\itemize{
\item it had a median coefficient of variation superior to 0.6
\item it had a log2 median intensity outside (6, 8)
\item it contained less than 750 peptides
}
}

\section{Building the peptide matrix}{


PSMs belonging to the same peptide were aggregating using the
median value. Some peptides were mapped to a different protein
depending on the MS acquisition run. To solve this issue, a
majority vote was applied to assign a single protein to each
peptide. Protein IDs were translated into gene symbols using the
\code{ensembldb} package.
}

\references{
Leduc, Andrew, R. Gray Huffman, Joshua Cantlon, Saad Khan, and
Nikolai Slavov. 2022. “Exploring Functional Protein Covariation
across Single Cells Using nPOP.” Genome Biology 23 (1): 261.
}
\author{
Christophe Vanderaa, Laurent Gatto
}
\keyword{datasets}
