% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBatchVariance.R
\name{plotSCEBatchFeatureMean}
\alias{plotSCEBatchFeatureMean}
\title{Plot mean feature value in each batch of a SingleCellExperiment object}
\usage{
plotSCEBatchFeatureMean(
  inSCE,
  useAssay = NULL,
  useReddim = NULL,
  useAltExp = NULL,
  batch = "batch",
  xlab = "batch",
  ylab = "Feature Mean",
  ...
)
}
\arguments{
\item{inSCE}{\linkS4class{SingleCellExperiment} inherited object.}

\item{useAssay}{A single character. The name of the assay that stores the
value to plot. For \code{useReddim} and \code{useAltExp} also. Default
\code{NULL}.}

\item{useReddim}{A single character. The name of the dimension reduced
matrix that stores the value to plot. Default \code{NULL}.}

\item{useAltExp}{A single character. The name of the alternative experiment
that stores an assay of the value to plot. Default \code{NULL}.}

\item{batch}{A single character. The name of batch annotation column in
\code{colData(inSCE)}. Default \code{"batch"}.}

\item{xlab}{label for x-axis. Default \code{"batch"}.}

\item{ylab}{label for y-axis. Default \code{"Feature Mean"}.}

\item{...}{Additional arguments passed to \code{.ggViolin}.}
}
\value{
ggplot
}
\description{
Plot mean feature value in each batch of a SingleCellExperiment object
}
\examples{
data('sceBatches', package = 'singleCellTK')
plotSCEBatchFeatureMean(sceBatches, useAssay = "counts")
}
