% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlReports.R
\name{reportSeuratFeatureSelection}
\alias{reportSeuratFeatureSelection}
\title{Generates an HTML report for Seurat Feature Selection and returns the
SCE object with the results computed and stored inside the object.}
\usage{
reportSeuratFeatureSelection(
  inSCE,
  variable.features = 2000,
  runHVG = TRUE,
  plotHVG = TRUE,
  outputFile = NULL,
  outputPath = NULL,
  subtitle = NULL,
  authors = NULL,
  showSession = FALSE,
  pdf = FALSE,
  forceRun = TRUE
)
}
\arguments{
\item{inSCE}{Input \code{\link[SingleCellExperiment]{SingleCellExperiment}}
object.}

\item{variable.features}{A numeric value indicating the number of top variable
features to identify. Default \code{2000}.}

\item{runHVG}{A logical value indicating if the feature selection algorithm
should be run or not. Default \code{TRUE}.}

\item{plotHVG}{A logical value indicating if the mean-to-variance plot
of the top variable feature should be visualized or not. Default \code{TRUE}.}

\item{outputFile}{Specify the name of the generated output HTML file.
If \code{NULL} then the output file name will be based on the name of the
Rmarkdown template. Default \code{NULL}.}

\item{outputPath}{Specify the name of the output directory to save the
rendered HTML file. If \code{NULL} the file is stored to the current
working directory. Default \code{NULL}.}

\item{subtitle}{A character value specifying the subtitle to use in the
report. Default \code{NULL}.}

\item{authors}{A character value specifying the names of the authors to use
in the report. Default \code{NULL}.}

\item{showSession}{A logical value indicating if session information
should be displayed or not. Default is \code{FALSE}.}

\item{pdf}{A logical value indicating if a pdf should also be generated for
each figure in the report. Default is \code{FALSE}.}

\item{forceRun}{A logical value indicating if all computations previously
computed should be re-calculated regardless if these computations are
available in the input object. Default is \code{TRUE}.}
}
\value{
A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object
 with computations stored.
}
\description{
Generates an HTML report for Seurat Feature Selection and returns the
SCE object with the results computed and stored inside the object.
}
