% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBatchVariance.R
\name{plotBatchCorrCompare}
\alias{plotBatchCorrCompare}
\title{Plot comparison of batch corrected result against original assay}
\usage{
plotBatchCorrCompare(
  inSCE,
  corrMat,
  batch = NULL,
  condition = NULL,
  origAssay = NULL,
  origLogged = NULL,
  method = NULL,
  matType = NULL
)
}
\arguments{
\item{inSCE}{\linkS4class{SingleCellExperiment} inherited object.}

\item{corrMat}{A single character indicating the name of the corrected matrix.}

\item{batch}{A single character. The name of batch annotation column in
\code{colData(inSCE)}.}

\item{condition}{A single character. The name of an additional covariate
annotation column in \code{colData(inSCE)}.}

\item{origAssay}{A single character indicating what the original assay used
for batch correction is.}

\item{origLogged}{Logical scalar indicating whether \code{origAssay} is
log-normalized.}

\item{method}{A single character indicating the name of the batch correction
method. Only used for the titles of plots.}

\item{matType}{A single character indicating the type of the batch correction
result matrix, choose from \code{"assay"}, \code{"altExp"},
\code{"reducedDim"}.}
}
\value{
An object of class \code{"gtable"}, combining four \code{ggplot}s.
}
\description{
Plot comparison of batch corrected result against original assay
}
\details{
Four plots will be combined. Two of them are violin/box-plots for
percent variance explained by the batch variation, and optionally the
covariate, for original and corrected. The other two are UMAPs of the
original assay and the correction result matrix. If SCTK batch correction
methods are performed in advance, this function will automatically detect
necessary input. Otherwise, users can also customize the input. Future
improvement might include solution to reduce redundant UMAP calculation.
}
\examples{
data("sceBatches")
logcounts(sceBatches) <- log1p(counts(sceBatches))
sceBatches <- runLimmaBC(sceBatches)
plotBatchCorrCompare(sceBatches, "LIMMA", condition = "cell_type")
}
\author{
Yichen Wang
}
