% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkPairedEnd.R
\name{checkPairedEnd}
\alias{checkPairedEnd}
\title{Test whether a bam file is single-end or paired-end}
\usage{
checkPairedEnd(file, yieldSize = 1e+05)
}
\arguments{
\item{file}{the input bam file. Your bamfile should be sorted and have an 
index file located at the same path as well.}

\item{yieldSize}{the number of reads to be checked, 100000 by default.}
}
\value{
return TRUE if the input file is paired end, and FALSE if it is 
single end
}
\description{
Check the first 100000 first reads of the bam file to see 
whether it is single-end or paired-end
}
\examples{
file <- system.file('extdata','s1.sorted.bam',package = 'strandCheckR')
checkPairedEnd(file)
}
