% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ccposition_den.R
\name{plot_ccposition_den}
\alias{plot_ccposition_den}
\title{Plot cell cycle position kernel density stratified by a factor}
\arguments{
\item{theta.v}{The cell cycle position - a numeric vector with range between 0 to 2pi.}

\item{color_var.v}{A factor variable to stratify \code{theta.v}, such as samples or 'CCStage'. The length of it should equal to the length of \code{theta.v}.}

\item{color_name}{The name of the color_var.v to be used in the legend.}

\item{palette.v}{A string vector to give the color names. It should has the length of the number of levels of \code{color_var.v}. If not given, the 'Set1' palette will be used.
(See \code{\link[RColorBrewer]{display.brewer.all}}) If the number of levels
of \code{color_var.v} is greater than 8, only the top 8 levels of most cell
 will be shown. You can show them all by feeding enough colors in \code{palette.v}. Default: NULL}

\item{fig.title}{The title of the figure. Default: NULL}

\item{type}{It can be either of 'linear' or 'circular'. 'linear' corresponds to Cartesian coordinate system and 'circular' for polar coordinate system. Default: 'linear'}

\item{bw}{The smoothing bandwidth to be used. It is equal to the concentration parameter of the von Mises distribution. See \code{\link[circular]{density.circular}}. Default: 30}

\item{weighted}{Whether the density should be weighted on the percentage of each level of \code{color_var.v}. Default: FALSE}

\item{line.size}{The size of the line used by \code{\link[ggplot2]{geom_path}}. Default: 0.5}

\item{line.alpha}{The alpha value of the line used by \code{\link[ggplot2]{geom_path}}. Default: 0.5}

\item{addRug}{Whether to add rug on the bottom of the linear density plot or an inner circle on the circular plot to show the continuous scale of theta. Default: TRUE}

\item{RugPalette.v}{The palette used for the rug plot. If not given, it will used the same default palette as in \code{\link{plot_emb_circle_scale}}.}

\item{...}{Other arguments accepted by \code{\link[ggplot2]{geom_path}}.}
}
\value{
A ggplot object
}
\description{
The function will compute and plot cell cycle position kernel density.
}
\details{
The function first estimates kernel density using the von Mises distribution. Then,
it plots out the density in the polar coordinate system or Cartesian coordinate system. Different colors
represents different levels of \code{color_var.v} and the dashed black line is the marginal distribution of all cells.
}
\examples{
data(neurosphere_example, package = "tricycle")
neurosphere_example <- estimate_cycle_position(neurosphere_example)
plot_ccposition_den(neurosphere_example$tricyclePosition, neurosphere_example$sample, "sample")

neurosphere_example <- estimate_Schwabe_stage(neurosphere_example,
 gname.type = "ENSEMBL", species = "mouse")
plot_ccposition_den(neurosphere_example$tricyclePosition, neurosphere_example$CCStage, "CCStage")
}
\seealso{
\code{\link{estimate_Schwabe_stage}}, for inferring 5 stages of cell cycle
}
\author{
Shijie C. Zheng
}
