% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMixedModelDE.R
\name{classifyTestsF,MArrayLM2-method}
\alias{classifyTestsF,MArrayLM2-method}
\title{Multiple Testing Genewise Across Contrasts}
\usage{
\S4method{classifyTestsF}{MArrayLM2}(
  object,
  cor.matrix = NULL,
  df = Inf,
  p.value = 0.01,
  fstat.only = FALSE
)
}
\arguments{
\item{object}{numeric matrix of t-statistics or an 'MArrayLM2' object from which the t-statistics may be extracted.}

\item{cor.matrix}{covariance matrix of each row of t-statistics.  Defaults to the identity matrix.}

\item{df}{numeric vector giving the degrees of freedom for the t-statistics.  May have length 1 or length equal to the number of rows of tstat.}

\item{p.value}{numeric value between 0 and 1 giving the desired size of the test}

\item{fstat.only}{logical, if 'TRUE' then return the overall F-statistic as for 'FStat' instead of classifying the test results}
}
\description{
For each gene, classify a series of related t-statistics as up, down or not significant.
}
\details{
Works like limma::classifyTestsF, except object can have a list of covariance matrices object$cov.coefficients.list, instead of just one in object$cov.coefficients
}
\seealso{
\code{limma::classifyTestsF}
}
