datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Bt.eg <- function() showQCData("org.Bt.eg", datacache)
org.Bt.eg_dbconn <- function() dbconn(datacache)
org.Bt.eg_dbfile <- function() dbfile(datacache)
org.Bt.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Bt.eg_dbInfo <- function() dbInfo(datacache)

org.Bt.egORGANISM <- "Bos taurus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Bt.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("BOVINE_DB", "org.Bt.eg", "Bovine", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Bt.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Bt.eg_dbconn())
}

