% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_DoReMiTra_datasets.R
\name{compare_DoReMiTra_datasets}
\alias{compare_DoReMiTra_datasets}
\title{Compare two or more dataset from the DoReMiTra collection}
\usage{
compare_DoReMiTra_datasets(
  se_list,
  fields = c("Radiation_type", "Dose", "Sex", "Time_point", "Organism")
)
}
\arguments{
\item{se_list}{names of the se objects to be compared}

\item{fields}{a character vector of the main metadata info}
}
\value{
a dataframe comparing the metadata of the selected datasets
}
\description{
This function compares the essential metadata information of 2 or more SE objects
including radiation type, dose, time point, etc.
}
\examples{
se1 <- get_DoReMiTra_data("SE_Paul_2010_InVivo_GSE23393_GPL6480")
se2 <- get_DoReMiTra_data("SE_Amundson_2011_InVivo_GSE20162_GPL6480")
se_list<- list(Amundson = se1, Paul= se2)
compare_DoReMiTra_datasets(se_list = se_list)

}
