% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_DoReMiTra_se.R
\name{summarize_DoReMiTra_se}
\alias{summarize_DoReMiTra_se}
\title{Summarize the metadata of a SummarizedExperiment object from the DoReMiTra collection}
\usage{
summarize_DoReMiTra_se(se)
}
\arguments{
\item{se}{The name of the SE object as defined by the user}
}
\value{
A character string containing a essential information about the dataset metadata
}
\description{
#' Provides a concise overview of a \code{SummarizedExperiment} object from the DoReMiTra collection.
Displays information such as the number of samples, metadata content, and
key experimental conditions like radiation type, organism, and platform.
}
\examples{
se <- get_DoReMiTra_data("SE_Ghandhi_2018_InVivo_GSE84898_GPL13497")
summarize_DoReMiTra_se(se)
}
