% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_target.R
\name{align_target_bowtie}
\alias{align_target_bowtie}
\title{Align microbiome reads to set of indexed Bowtie2 libraries}
\usage{
align_target_bowtie(
  read1,
  read2 = NULL,
  lib_dir,
  libs,
  align_dir,
  align_file,
  bowtie2_options = NULL,
  threads = 1,
  overwrite = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{read1}{Path to the .fastq file to align.}

\item{read2}{Optional: Location of the mate pair .fastq file to align.}

\item{lib_dir}{Path to the directory that contains the Bowtie2 indexes.}

\item{libs}{The basename of the Bowtie2 indexes to align against (without
trailing .bt2 or .bt2l extensions).}

\item{align_dir}{Path to the directory where the output alignment file should
be created.}

\item{align_file}{The basename of the output alignment file (without trailing
.bam extension).}

\item{bowtie2_options}{Optional: Additional parameters that can be passed to
the align_target_bowtie() function. To see all the available parameters use
Rbowtie2::bowtie2_usage(). See Details for default parameters. NOTE: Users
should pass all their parameters as one string and if optional parameters
are given then the user is responsible for entering all the parameters to
be used by Bowtie2. The only parameter that should NOT be specified here is
the number of threads.}

\item{threads}{The number of threads that can be utilized by the function.
Default is 1 thread.}

\item{overwrite}{Whether existing files should be overwritten. Default is
FALSE.}

\item{quiet}{Turns off most messages. Default is \code{TRUE}.}
}
\value{
Returns the path to where the output alignment file is stored.
}
\description{
This is the main MetaScope target library mapping function, using Rbowtie2
and multiple libraries. Aligns to each library separately, filters unmapped
reads from each file, and then merges and sorts the .bam files from each
library into one output file. If desired, output can be passed to
`filter_host_bowtie()` to remove reads that also map to filter library
genomes.
}
\details{
The default parameters are the same that PathoScope 2.0 uses.
"--very-sensitive-local -k 100 --score-min L,20,1.0"

If you experience any issues with reading the input files, make sure that
the file(s) are not located in a read-only folder. This can be circumvented
by copying files to a new location before running the function.
}
\examples{
#### Align example reads to an example reference library using Rbowtie2
\donttest{
## Create temporary directory to store file
target_ref_temp <- tempfile()
dir.create(target_ref_temp)

tmp_accession <- system.file("extdata", "example_accessions.sql", package = "MetaScope")

## Dowload reference genome
MetaScope::download_refseq("Morbillivirus hominis",
                           reference = FALSE,
                           representative = FALSE,
                           compress = TRUE,
                           out_dir = target_ref_temp,
                           caching = TRUE,
                           accession_path = tmp_accession
)

## Create temporary directory to store the indices
index_temp <- tempfile()
dir.create(index_temp)

## Create bowtie2 index
MetaScope::mk_bowtie_index(
  ref_dir = target_ref_temp,
  lib_dir = index_temp,
  lib_name = "target",
  overwrite = TRUE
)

## Create temporary directory for final file
output_temp <- tempfile()
dir.create(output_temp)

## Get path to example reads
readPath <- system.file("extdata", "virus_example.fastq",
                        package = "MetaScope")

## Align to target genomes
target_map <-
  MetaScope::align_target_bowtie(
    read1 = readPath,
    lib_dir = index_temp,
    libs = "target",
    align_dir = output_temp,
    align_file = "bowtie_target",
    overwrite = TRUE,
    bowtie2_options = "--very-sensitive-local"
  )

## Remove extra folders
unlink(target_ref_temp, recursive = TRUE)
unlink(index_temp, recursive = TRUE)
unlink(output_temp, recursive = TRUE)
}
}
