% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bt2_regular_params}
\alias{bt2_regular_params}
\title{A universal parameter object for Bowtie 2 metagenomic or non-16S alignment}
\format{
list
}
\usage{
data(bt2_regular_params)
}
\description{
This character string provides several Bowtie 2 options to provide a 95% identity
alignment useful for metagenomes. This object can be used with functions that
use the Bowtie 2 aligner through the \code{Rbowtie2} package, namely
\code{align_target_bowtie()} and \code{filter_host_bowtie}. These settings
can be substituted for default settings by passing \code{} to the
\code{bowtie2_options} argument.
}
\details{
The default parameters listed in this object are
"--local -R 2 -N 0 -L 25 -i S,1,0.75 -k 5 --score-min L,0,1.7".

Further delineation of Bowtie 2 parameters is provided in the
\href{https://bowtie-bio.sourceforge.net/bowtie2/manual.shtml}{Bowtie 2
manual}.
}
\examples{
data("bt2_regular_params")

}
\keyword{datasets}
