% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metascope_id.R
\name{count_matches}
\alias{count_matches}
\title{Count the number of base lengths in a CIGAR string for a given operation}
\usage{
count_matches(x, char = "M")
}
\arguments{
\item{x}{Character. A CIGAR string for a read to be parsed. Examples of
possible operators include "M", "D", "I", "S", "H", "=", "P", and "X".}

\item{char}{A single letter representing the operation to total for the
given string.}
}
\value{
an integer number representing the total number of alignment
operations for the read that was summarized by the input CIGAR string.
}
\description{
The 'CIGAR' (Compact Idiosyncratic Gapped Alignment Report) string is how the
SAM/BAM format represents spliced alignments. This function will accept a
CIGAR string for a single read and a single character indicating the
operation to be parsed in the string. An operation is a type of column that
appears in the alignment, e.g. a match or gap. The integer following the
operator specifies a number of consecutive operations. The
\code{count_matches()} function will identify all occurrences of the operator
in the string input, add them, and return an integer number representing the
total number of operations for the read that was summarized by the input
CIGAR string.
}
\details{
This function is best used on a vector of CIGAR strings using an apply
function (see examples).
}
\examples{
# A single cigar string: 3M + 3M + 5M
cigar1 <- "3M1I3M1D5M"
count_matches(cigar1, char = "M")

# Parse with operator "P": 2P
cigar2 <- "4M1I2P9M"
count_matches(cigar2, char = "P")

# Apply to multiple strings: 1I + 1I + 5I
cigar3 <- c("3M1I3M1D5M", "4M1I1P9M", "76M13M5I")
vapply(cigar3, count_matches, char = "I",
       FUN.VALUE = numeric(1))

}
